<?php

// Database connection
require 'koneksi.php';
require 'header1.php';

$sesi = $_SESSION['level'];
if ($sesi == "") {
    header("location: login.php");
}


// If the submit button is clicked, add data to the database
if (isset($_POST["submit"])) {
    $alternative = $_POST["alternatif"];
    $name = $_POST["nama"];
    $student_id = $_POST["nim"];
    $email = $_POST["email"];

    // Insert data into the student table
    $query = "INSERT INTO mahasiswa (alternatif, nama, nim, email) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("ssss", $alternative, $name, $student_id, $email);

    if ($stmt->execute()) {
        echo "
        <script>
            alert('Data successfully added!');
            window.location = 'tambah_mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Failed to add data!');
        </script>";
    }
}

// If the delete button is clicked
if (isset($_GET['hapus'])) {
    $id = $_GET['hapus'];

    // Get the alternative before deleting the student
    $query_get_alternative = "SELECT alternatif FROM mahasiswa WHERE id = ?";
    $stmt_get = $conn->prepare($query_get_alternative);
    $stmt_get->bind_param("i", $id);
    $stmt_get->execute();
    $stmt_get->bind_result($alternative);
    $stmt_get->fetch();
    $stmt_get->close();

    // Delete from the student table
    $query = "DELETE FROM mahasiswa WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        // Also delete from the input_nilai1 table based on the same alternative
        $query_delete_grade = "DELETE FROM input_nilai1 WHERE alternatif = ?";
        $stmt_delete_grade = $conn->prepare($query_delete_grade);
        $stmt_delete_grade->bind_param("s", $alternative);
        $stmt_delete_grade->execute();

        echo "
        <script>
            alert('Data successfully deleted!');
            window.location = 'tambah_mahasiswa.php';
        </script>";
    } else {
        echo "
        <script>
            alert('Failed to delete data!');
        </script>";
    }
}
?>


<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid py-4">

            <h2 class="mb-4 text-center">Add Student Data Form</h2>
        </div>
            <!-- Add Student Form -->
            <form action="" method="post">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Alternative</label>
                        <input type="text" name="alternatif" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Name</label>
                        <input type="text" name="nama" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Student ID</label>
                        <input type="text" name="nim" class="form-control form-control-lg" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label text-center">Email</label>
                        <input type="email" name="email" class="form-control form-control-lg" required>
                    </div>
                </div>
                <div class="text-center">
                    <button class="btn btn-primary btn-lg px-4 py-2" type="submit" name="submit">
                    <i class="fas fa-plus"></i> Add Data
                    </button>
                </div>
            </form>
            <br><br>
 
<br><br>
            <!-- Student List Table -->
            <h3 class="mb-3 text-center">Student List</h3>
            <div class="table-responsive">
                <table class="table table-bordered table-sm align-middle text-center">
                    <thead class="table-primary">
                        <tr style="height: 40px;">
                            <th>No</th>
                            <th>Alternative</th>
                            <th>Student Name</th>
                            <th>Student ID</th>
                            <th>Email</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $result = mysqli_query($conn, "SELECT * FROM mahasiswa ORDER BY id DESC");
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) :
                        ?>
                            <tr style="height: 35px;">
                                <td><?= $no++; ?></td>
                                <td><?= htmlspecialchars($row['alternatif']); ?></td>
                                <td><?= htmlspecialchars($row['nama']); ?></td>
                                <td><?= htmlspecialchars($row['nim']); ?></td>
                                <td><?= htmlspecialchars($row['email']); ?></td>
                                <td>
                                    <a href="ubah_mahasiswa.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                    <a href="?hapus=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete?');">Delete</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</div>
